/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.upgrddat;

import com.ibm.hwmca.base.upgrddat.UpgradeDataClassFilter;
import com.ibm.hwmca.base.upgrddat.UpgradeDataConstants;
import com.ibm.hwmca.base.upgrddat.UpgradeDataErrorIds;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.upgrddat.UpgradeData;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class UpgradeDataBImpl
implements UpgradeData,
UpgradeDataErrorIds,
UpgradeDataConstants {
    private static final String TRACE_MASKT = "XSAVUBIT";
    private static final String TRACE_MASKF = "XSAVUBIF";
    private static final String TRACE_MASKD = "XSAVUBID";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(3, "UpgradeDataBImpl");
    public final String traceFileName = "UpgradeDataTrace.lst";
    private String filePrefix = "UpgradeData.";
    protected String file;
    protected String versionNumber;
    protected String traceFile;
    private boolean critical_error_flag = false;

    public UpgradeDataBImpl() throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataBImpl() Constructor");
        try {
            this.file = "UpgradeBase.trm";
            this.file = BaseFileControl.getFilePath("UpgradeBase.trm") + "UpgradeBase.trm";
            this.traceFile = BaseFileControl.getFilePath("UpgradeDataTrace.lst") + "UpgradeDataTrace.lst";
            this.versionNumber = "00001";
        }
        catch (HException exc) {
            Trace.trace(TRACE_MASKF, "An Exception occurred finding pathing for table file");
            Trace.trace(TRACE_MASKF, exc);
            UpgradeDataException hexe = new UpgradeDataException(exc);
            hexe.setCriticalDataError();
            new FrameworkLog(_logInfo, 16433, hexe).log();
            throw hexe;
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataBImpl() Constructor");
    }

    public String getUpgradeDataVersion() throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataBImpl.getUpgradeDataVersion()");
        Trace.trace(TRACE_MASKF, "Version number is : " + this.versionNumber);
        Trace.trace(TRACE_MASKT, "<- UpgradeDataBImpl.getUpgradeDataVersion()");
        return this.versionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveUpgradeData(OutputStream fileNameZip) throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataBImpl.saveUpgradeData(OutputStream StreamNameOut)");
        byte[] buf = new byte[1024];
        ZipOutputStream zos = null;
        try {
            try {
                Trace.trace(TRACE_MASKF, "File output stream passed in is : " + fileNameZip);
                Date date = new Date();
                FileWriter fileTrace = new FileWriter(this.traceFile, true);
                fileTrace.write("\n\nUpgradeDataBImpl Save running\n");
                fileTrace.write("\n" + date + "\n\n");
                fileTrace.write("File stream passed in is : " + fileNameZip + "\n");
                fileNameZip.flush();
                try {
                    try {
                        zos = new ZipOutputStream(fileNameZip);
                        zos.setMethod(8);
                        zos.setComment("compressed");
                        String filetmp = this.traceFile + "tmp";
                        Trace.trace(TRACE_MASKF, "zipentry filetmp is:" + filetmp + ".");
                        ZipEntry ze1 = new ZipEntry(filetmp);
                        ze1.setSize(this.file.length());
                        zos.putNextEntry(ze1);
                        zos.write(this.file.getBytes(), 0, this.file.length());
                        String path = this.file;
                        Trace.trace(TRACE_MASKF, "using table file " + path + ".");
                        fileTrace.write("Table name being used is : " + path + "\n\n");
                        BufferedReader in = new BufferedReader(new FileReader(path));
                        String line = null;
                        Object newFileName = null;
                        do {
                            Object var28_41;
                            if ((line = in.readLine()) == null || (line = line.trim()).length() <= 0 || line.substring(0, 1).equals("#") || line.substring(0, 1).equals("*")) continue;
                            Trace.trace(TRACE_MASKF, "creating class [" + line + "].");
                            fileTrace.write("User class name is : " + line + "\n");
                            StringTokenizer parser = new StringTokenizer(line);
                            String class_name = null;
                            String method_name = null;
                            int token_count = parser.countTokens();
                            UpgradeData userClass = null;
                            FileInputStream is = null;
                            try {
                                UpgradeDataException hexe;
                                try {
                                    int len;
                                    Trace.trace(TRACE_MASKF, "Number of tokens is " + token_count);
                                    if (token_count > 1) {
                                        class_name = parser.nextToken();
                                        method_name = parser.nextToken();
                                        Trace.trace(TRACE_MASKF, "class name is " + class_name);
                                        Trace.trace(TRACE_MASKF, "method name is " + method_name);
                                    }
                                    if (token_count == 1) {
                                        userClass = (UpgradeData)Class.forName(line).newInstance();
                                        Trace.trace(TRACE_MASKF, "class [" + line + "] created.");
                                    } else {
                                        Trace.trace(TRACE_MASKF, "Start class [" + class_name + "].");
                                        Class<?> singleClass = Class.forName(class_name);
                                        Trace.trace(TRACE_MASKF, "Start method [" + method_name + "].");
                                        Method singleMethod = singleClass.getMethod(method_name, null);
                                        Trace.trace(TRACE_MASKF, "Start method done.");
                                        userClass = (UpgradeData)singleMethod.invoke(null, null);
                                        Trace.trace(TRACE_MASKF, "invoke method done.");
                                    }
                                    Trace.trace(TRACE_MASKF, "Create class classB and get class name.");
                                    Class<?> classB = userClass.getClass();
                                    String classNameRunning = classB.getName();
                                    Trace.trace(TRACE_MASKF, "Class Name running is : " + classNameRunning);
                                    Trace.trace(TRACE_MASKF, "Call getUpgradeDataVersion to return version number");
                                    String versionNumber = userClass.getUpgradeDataVersion();
                                    Trace.trace(TRACE_MASKF, "Version Number returned is : " + versionNumber);
                                    String fulluserName = this.filePrefix + classNameRunning + "!" + versionNumber;
                                    Trace.trace(TRACE_MASKF, "Full user name is : " + fulluserName);
                                    path = BaseFileControl.getFilePath(fulluserName);
                                    path = path + fulluserName;
                                    Trace.trace(TRACE_MASKF, "full path name is : " + path);
                                    File fileobject = new File(path);
                                    if (fileobject.exists()) {
                                        Trace.trace(TRACE_MASKF, "File " + fileobject.getAbsolutePath() + " exists");
                                        fileobject.delete();
                                        if (fileobject.exists()) {
                                            Trace.trace(TRACE_MASKF, "File " + fileobject.getAbsolutePath() + " was not deleted");
                                        } else {
                                            Trace.trace(TRACE_MASKF, "File " + path + " was deleted");
                                        }
                                    }
                                    Trace.trace(TRACE_MASKF, "Open File Output Stream" + path);
                                    FileOutputStream userStreamOut = new FileOutputStream(path);
                                    Trace.trace(TRACE_MASKF, "FileOutputStream stream " + path + " created");
                                    try {
                                        Trace.trace(TRACE_MASKF, "Call saveUpgrade data to create user file");
                                        userClass.saveUpgradeData(userStreamOut);
                                        Trace.trace(TRACE_MASKF, "Return from saveUpgrade data to save data to output Stream.");
                                        fileTrace.write("Data successfully saved to " + path + " \n");
                                    }
                                    catch (UpgradeDataException hexe2) {
                                        Trace.trace(TRACE_MASKF, "UpgradeDataExecption was thrown: " + hexe2);
                                        fileTrace.write("UpgradeData Exception on " + path + " call\n");
                                        if (hexe2.isCriticalDataError()) {
                                            Trace.trace(TRACE_MASKF, "Critical Data error flag is set ");
                                            fileTrace.write("Critical Data error flag is set\n");
                                            new FrameworkLog(_logInfo, 16437, hexe2).log();
                                            this.critical_error_flag = true;
                                        }
                                    }
                                    catch (Exception e) {
                                        Trace.trace(TRACE_MASKF, "Exception on call saveUpgrade data");
                                        fileTrace.write("Exception on call saveUpgrade data\n");
                                    }
                                    Trace.trace(TRACE_MASKF, "Return from call saveUpgrade data");
                                    Trace.trace(TRACE_MASKF, "Close File Output Stream " + path);
                                    userStreamOut.close();
                                    Trace.trace(TRACE_MASKF, "File Output Stream " + path + " Closed.");
                                    String str = path;
                                    fileobject = new File(str);
                                    ZipEntry ze = new ZipEntry(str);
                                    is = new FileInputStream(str);
                                    Trace.trace(TRACE_MASKF, "str File length is : " + fileobject.length());
                                    Trace.trace(TRACE_MASKF, "Zip entry created");
                                    zos.putNextEntry(ze);
                                    Trace.trace(TRACE_MASKF, "Entry written to zip File");
                                    while ((len = is.read(buf)) >= 0) {
                                        zos.write(buf, 0, len);
                                    }
                                    Trace.trace(TRACE_MASKF, "File " + str + " written to Zip file");
                                    fileTrace.write(str + " written to zip file.\n\n");
                                }
                                catch (IllegalAccessException e) {
                                    Trace.trace(TRACE_MASKF, "Illegal Access error");
                                    hexe = new UpgradeDataException(e);
                                    hexe.setCriticalDataError();
                                    new FrameworkLog(_logInfo, 16443, e).log();
                                    this.critical_error_flag = true;
                                    var28_41 = null;
                                    Trace.trace(TRACE_MASKF, "Doing final cleanup for try 04 block");
                                    if (is == null) continue;
                                    is.close();
                                    continue;
                                }
                                catch (InvocationTargetException e) {
                                    Trace.trace(TRACE_MASKF, "Invocation Target error");
                                    hexe = new UpgradeDataException(e);
                                    hexe.setCriticalDataError();
                                    new FrameworkLog(_logInfo, 16444, e).log();
                                    this.critical_error_flag = true;
                                    var28_41 = null;
                                    Trace.trace(TRACE_MASKF, "Doing final cleanup for try 04 block");
                                    if (is == null) continue;
                                    is.close();
                                    continue;
                                }
                                catch (InstantiationException e) {
                                    Trace.trace(TRACE_MASKF, "Instantiation error");
                                    hexe = new UpgradeDataException(e);
                                    hexe.setCriticalDataError();
                                    new FrameworkLog(_logInfo, 16442, e).log();
                                    this.critical_error_flag = true;
                                    var28_41 = null;
                                    Trace.trace(TRACE_MASKF, "Doing final cleanup for try 04 block");
                                    if (is == null) continue;
                                    is.close();
                                    continue;
                                }
                                catch (NoSuchMethodException e) {
                                    Trace.trace(TRACE_MASKF, "No such method error");
                                    hexe = new UpgradeDataException(e);
                                    hexe.setCriticalDataError();
                                    new FrameworkLog(_logInfo, 16441, e).log();
                                    this.critical_error_flag = true;
                                    var28_41 = null;
                                    Trace.trace(TRACE_MASKF, "Doing final cleanup for try 04 block");
                                    if (is == null) continue;
                                    is.close();
                                    continue;
                                }
                                catch (ClassNotFoundException e) {
                                    Trace.trace(TRACE_MASKF, "Class not found error");
                                    hexe = new UpgradeDataException(e);
                                    hexe.setCriticalDataError();
                                    new FrameworkLog(_logInfo, 16440, e).log();
                                    this.critical_error_flag = true;
                                    var28_41 = null;
                                    Trace.trace(TRACE_MASKF, "Doing final cleanup for try 04 block");
                                    if (is == null) continue;
                                    is.close();
                                    continue;
                                }
                                catch (NoSuchElementException e) {
                                    Trace.trace(TRACE_MASKF, "String tokenizer no such element error");
                                    hexe = new UpgradeDataException(e);
                                    hexe.setCriticalDataError();
                                    new FrameworkLog(_logInfo, 16436, e).log();
                                    this.critical_error_flag = true;
                                    var28_41 = null;
                                    Trace.trace(TRACE_MASKF, "Doing final cleanup for try 04 block");
                                    if (is == null) continue;
                                    is.close();
                                    continue;
                                }
                                catch (IOException e) {
                                    Trace.trace(TRACE_MASKF, "IO error while running through the table file.");
                                    hexe = new UpgradeDataException(e);
                                    hexe.setCriticalDataError();
                                    new FrameworkLog(_logInfo, 16438, e).log();
                                    this.critical_error_flag = true;
                                    var28_41 = null;
                                    Trace.trace(TRACE_MASKF, "Doing final cleanup for try 04 block");
                                    if (is == null) continue;
                                    is.close();
                                    continue;
                                }
                                catch (HException e) {
                                    Trace.trace(TRACE_MASKF, "H Exception while running through the table file.");
                                    hexe = new UpgradeDataException(e);
                                    hexe.setCriticalDataError();
                                    new FrameworkLog(_logInfo, 16439, e).log();
                                    this.critical_error_flag = true;
                                    var28_41 = null;
                                    Trace.trace(TRACE_MASKF, "Doing final cleanup for try 04 block");
                                    if (is == null) continue;
                                    is.close();
                                    continue;
                                }
                                var28_41 = null;
                            }
                            catch (Throwable throwable) {
                                var28_41 = null;
                                Trace.trace(TRACE_MASKF, "Doing final cleanup for try 04 block");
                                if (is != null) {
                                    is.close();
                                }
                                throw throwable;
                            }
                            Trace.trace(TRACE_MASKF, "Doing final cleanup for try 04 block");
                            if (is == null) continue;
                            is.close();
                        } while (line != null);
                        Trace.trace(TRACE_MASKF, "zip file closed.");
                        fileTrace.write("Zip file : " + fileNameZip + " closed\n\n");
                    }
                    catch (IOException e) {
                        Trace.trace(TRACE_MASKF, "IOException occurred: " + e);
                        UpgradeDataException hexe = new UpgradeDataException(e);
                        hexe.setCriticalDataError();
                        new FrameworkLog(_logInfo, 16435, hexe).log();
                        throw hexe;
                    }
                    Object var30_43 = null;
                }
                catch (Throwable throwable) {
                    Object var30_44 = null;
                    Trace.trace(TRACE_MASKF, "Doing final cleanup for try 03 block");
                    fileTrace.close();
                    zos.finish();
                    zos.close();
                    throw throwable;
                }
                Trace.trace(TRACE_MASKF, "Doing final cleanup for try 03 block");
                fileTrace.close();
                zos.finish();
                zos.close();
                Object var32_46 = null;
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "Unexpected Exception occurred base impl: " + e);
                UpgradeDataException hexe = new UpgradeDataException(e);
                hexe.setCriticalDataError();
                new FrameworkLog(_logInfo, 16434, hexe).log();
                throw hexe;
            }
        }
        catch (Throwable throwable) {
            Object var32_47 = null;
            Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradeDataBImpl.saveUpgradeData()");
            if (this.critical_error_flag) {
                Trace.trace(TRACE_MASKF, "critical_error flag set.");
                UpgradeDataException hexe = new UpgradeDataException("SaveUpgradeDataB error");
                hexe.setCriticalDataError();
                Trace.trace(TRACE_MASKF, "set criticalDataError for save and pass exception on.");
                throw hexe;
            }
            throw throwable;
        }
        Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradeDataBImpl.saveUpgradeData()");
        if (this.critical_error_flag) {
            Trace.trace(TRACE_MASKF, "critical_error flag set.");
            UpgradeDataException hexe = new UpgradeDataException("SaveUpgradeDataB error");
            hexe.setCriticalDataError();
            Trace.trace(TRACE_MASKF, "set criticalDataError for save and pass exception on.");
            throw hexe;
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataBImpl.saveUpgradeData(OutputStream StreamNameOut)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restoreUpgradeData(InputStream streamNameIn, String versionLevel) throws UpgradeDataException {
        block38: {
            byte[] readBuffer = new byte[4096];
            Trace.trace(TRACE_MASKT, "-> UpgradeDataBImpl.restoreUpgradeData(streamName, version)");
            Trace.trace(TRACE_MASKT, "UpgradeDataBImpl.restoreUpgradeData version is :" + versionLevel);
            try {
                try {
                    ZipEntry ze;
                    Date date = new Date();
                    FileWriter fileTrace = new FileWriter(this.traceFile, true);
                    fileTrace.write("\n\nUpgradeDataBImpl Restore Linux to Linux running\n");
                    fileTrace.write("\n" + date + "\n\n");
                    fileTrace.write("File stream passed in is : " + streamNameIn + "\n");
                    String upgradePath = BaseFileControl.getFilePath("UpgradeDataAllTowers.zip");
                    Trace.trace(TRACE_MASKF, "upgradePath is : " + upgradePath);
                    ZipInputStream zis = new ZipInputStream(streamNameIn);
                    while ((ze = zis.getNextEntry()) != null) {
                        String zipEntryName = ze.getName();
                        Trace.trace(TRACE_MASKF, "Zip entry name is :" + zipEntryName);
                        if (!zipEntryName.equals(this.file)) {
                            int bytesRead;
                            Trace.trace(TRACE_MASKF, "Restore file with data: " + zipEntryName);
                            File file = new File(zipEntryName);
                            file.createNewFile();
                            FileOutputStream fileOutput = new FileOutputStream(file);
                            while ((bytesRead = zis.read(readBuffer)) > 0) {
                                fileOutput.write(readBuffer, 0, bytesRead);
                            }
                            fileOutput.close();
                            Trace.trace(TRACE_MASKF, "File size written is :" + ze.getSize());
                            zis.closeEntry();
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "File data name is : " + zipEntryName + " skip this entry");
                    }
                    Trace.trace(TRACE_MASKF, "Close zip input stream");
                    zis.close();
                    String path = this.file;
                    Trace.trace(TRACE_MASKF, "using table file " + path + ".");
                    fileTrace.write("Table name being used is : " + path + "\n\n");
                    BufferedReader in = new BufferedReader(new FileReader(path));
                    String line = null;
                    Object newFileName = null;
                    do {
                        UpgradeDataException hexe;
                        if ((line = in.readLine()) == null || (line = line.trim()).length() <= 0 || line.substring(0, 1).equals("#") || line.substring(0, 1).equals("*")) continue;
                        Trace.trace(TRACE_MASKF, "creating class [" + line + "].");
                        fileTrace.write("User class name is : " + line + "\n");
                        StringTokenizer parser = new StringTokenizer(line);
                        String class_name = null;
                        String method_name = null;
                        int token_count = parser.countTokens();
                        UpgradeData userClass = null;
                        Object is = null;
                        try {
                            Trace.trace(TRACE_MASKF, "Number of tokens is " + token_count);
                            if (token_count > 1) {
                                class_name = parser.nextToken();
                                method_name = parser.nextToken();
                                Trace.trace(TRACE_MASKF, "class name is " + class_name);
                                Trace.trace(TRACE_MASKF, "method name is " + method_name);
                            }
                            if (token_count == 1) {
                                userClass = (UpgradeData)Class.forName(line).newInstance();
                                Trace.trace(TRACE_MASKF, "class [" + line + "] created.");
                            } else {
                                Trace.trace(TRACE_MASKF, "Start class [" + class_name + "].");
                                Class<?> singleClass = Class.forName(class_name);
                                Trace.trace(TRACE_MASKF, "Start method [" + method_name + "].");
                                Method singleMethod = singleClass.getMethod(method_name, null);
                                Trace.trace(TRACE_MASKF, "Start method done.");
                                userClass = (UpgradeData)singleMethod.invoke(null, null);
                                Trace.trace(TRACE_MASKF, "invoke method done.");
                            }
                            Trace.trace(TRACE_MASKF, "Create class classB and get class name.");
                            Class<?> classB = userClass.getClass();
                            String classNameRunning = classB.getName();
                            Trace.trace(TRACE_MASKF, "Class Name running is : " + classNameRunning);
                            String fullClassName = this.filePrefix + classNameRunning + "!";
                            Trace.trace(TRACE_MASKF, "Full Class name is : " + fullClassName);
                            File fpath = new File(upgradePath);
                            UpgradeDataClassFilter toweronly = new UpgradeDataClassFilter(fullClassName);
                            String[] foundFiles = fpath.list(toweronly);
                            for (int i1 = 0; i1 < foundFiles.length; ++i1) {
                                Trace.trace(TRACE_MASKF, "Found file : " + upgradePath + foundFiles[i1]);
                                Trace.trace(TRACE_MASKF, "foundfiles[i1] is : " + foundFiles[i1]);
                                fullClassName = upgradePath + foundFiles[i1];
                                Trace.trace(TRACE_MASKF, "Class data found in zip file : " + fullClassName);
                                int version_offset = fullClassName.lastIndexOf("!");
                                Trace.trace(TRACE_MASKF, "Version offset is : " + version_offset);
                                this.versionNumber = fullClassName.substring(version_offset + 1);
                                Trace.trace(TRACE_MASKF, "Version Number is : " + this.versionNumber);
                            }
                            Trace.trace(TRACE_MASKF, "Open File Input Stream" + fullClassName);
                            FileInputStream userStreamIn = new FileInputStream(fullClassName);
                            Trace.trace(TRACE_MASKF, "FileInputStream stream " + fullClassName + " created");
                            Trace.trace(TRACE_MASKF, "Call restoreUpgrade data to restore user data");
                            try {
                                userClass.restoreUpgradeData(userStreamIn, this.versionNumber);
                                Trace.trace(TRACE_MASKF, "Return from restoreUpgradeData to restore data from input Stream.");
                                fileTrace.write("Data successfully restored from " + fullClassName + "\n");
                            }
                            catch (UpgradeDataException e) {
                                Trace.trace(TRACE_MASKF, "UpgradeDataExecption was thrown: " + e);
                                fileTrace.write("UpgradeData Exception on " + line + " call\n");
                                if (e.isCriticalDataError()) {
                                    Trace.trace(TRACE_MASKF, "Critical Data error flag is set ");
                                    fileTrace.write("Critical Data error flag is set\n");
                                    new FrameworkLog(_logInfo, 16453, e).log();
                                    this.critical_error_flag = true;
                                }
                            }
                            catch (Exception e) {
                                Trace.trace(TRACE_MASKF, "Exception on call restoreUpgrade data");
                                fileTrace.write("Exception on call restoreUpgrade data\n");
                            }
                            Trace.trace(TRACE_MASKF, "Return from call restoreUpgrade data");
                            Trace.trace(TRACE_MASKF, "Close File Input Stream " + fullClassName);
                            userStreamIn.close();
                            Trace.trace(TRACE_MASKF, "File Input Stream " + fullClassName + " Closed.");
                        }
                        catch (IllegalAccessException e) {
                            Trace.trace(TRACE_MASKF, "Illegal Access error");
                            hexe = new UpgradeDataException(e);
                            hexe.setCriticalDataError();
                            new FrameworkLog(_logInfo, 16459, e).log();
                            this.critical_error_flag = true;
                        }
                        catch (InvocationTargetException e) {
                            Trace.trace(TRACE_MASKF, "Invocation Target error");
                            hexe = new UpgradeDataException(e);
                            hexe.setCriticalDataError();
                            new FrameworkLog(_logInfo, 16460, e).log();
                            this.critical_error_flag = true;
                        }
                        catch (InstantiationException e) {
                            Trace.trace(TRACE_MASKF, "Instantiation error");
                            hexe = new UpgradeDataException(e);
                            hexe.setCriticalDataError();
                            new FrameworkLog(_logInfo, 16458, e).log();
                            this.critical_error_flag = true;
                        }
                        catch (NoSuchMethodException e) {
                            Trace.trace(TRACE_MASKF, "No such method error");
                            hexe = new UpgradeDataException(e);
                            hexe.setCriticalDataError();
                            new FrameworkLog(_logInfo, 16457, e).log();
                            this.critical_error_flag = true;
                        }
                        catch (ClassNotFoundException e) {
                            Trace.trace(TRACE_MASKF, "Class not found error");
                            hexe = new UpgradeDataException(e);
                            hexe.setCriticalDataError();
                            new FrameworkLog(_logInfo, 16456, e).log();
                            this.critical_error_flag = true;
                        }
                        catch (NoSuchElementException e) {
                            Trace.trace(TRACE_MASKF, "String tokenizer no such element error");
                            hexe = new UpgradeDataException(e);
                            hexe.setCriticalDataError();
                            new FrameworkLog(_logInfo, 16452, e).log();
                            this.critical_error_flag = true;
                        }
                        catch (IOException e) {
                            Trace.trace(TRACE_MASKF, "IO error while running through the table file.");
                            new FrameworkLog(_logInfo, 16454, e).log(FrameworkLogAttributes.INFO_LOG);
                        }
                        finally {
                            Trace.trace(TRACE_MASKF, "Doing final cleanup for try 04 block");
                        }
                    } while (line != null);
                    fileTrace.close();
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "Caught IO Exception in restoreupgradeHarddrive()" + e);
                    new FrameworkLog(_logInfo, 16451, e).log();
                    Object var31_42 = null;
                    Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradeDataBImpl.restoreupgradeData()");
                    if (this.critical_error_flag) {
                        Trace.trace(TRACE_MASKF, "critical_error flag set.");
                        UpgradeDataException hexe = new UpgradeDataException("RestoreUpgradeDataB error");
                        hexe.setCriticalDataError();
                        Trace.trace(TRACE_MASKF, "set criticalDataError and pass exception on.");
                        throw hexe;
                    }
                    break block38;
                }
                catch (HException e) {
                    Trace.trace(TRACE_MASKF, "Caught HException in restoreupgradeHarddrive()" + e);
                    new FrameworkLog(_logInfo, 16450, e).log();
                    Object var31_43 = null;
                    Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradeDataBImpl.restoreupgradeData()");
                    if (this.critical_error_flag) {
                        Trace.trace(TRACE_MASKF, "critical_error flag set.");
                        UpgradeDataException hexe = new UpgradeDataException("RestoreUpgradeDataB error");
                        hexe.setCriticalDataError();
                        Trace.trace(TRACE_MASKF, "set criticalDataError and pass exception on.");
                        throw hexe;
                    }
                    break block38;
                }
                Object var31_41 = null;
            }
            catch (Throwable throwable) {
                Object var31_44 = null;
                Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradeDataBImpl.restoreupgradeData()");
                if (this.critical_error_flag) {
                    Trace.trace(TRACE_MASKF, "critical_error flag set.");
                    UpgradeDataException hexe = new UpgradeDataException("RestoreUpgradeDataB error");
                    hexe.setCriticalDataError();
                    Trace.trace(TRACE_MASKF, "set criticalDataError and pass exception on.");
                    throw hexe;
                }
                throw throwable;
            }
            Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradeDataBImpl.restoreupgradeData()");
            if (this.critical_error_flag) {
                Trace.trace(TRACE_MASKF, "critical_error flag set.");
                UpgradeDataException hexe = new UpgradeDataException("RestoreUpgradeDataB error");
                hexe.setCriticalDataError();
                Trace.trace(TRACE_MASKF, "set criticalDataError and pass exception on.");
                throw hexe;
            }
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataBImpl.restoreUpgradeData(streamName, version)");
    }
}

